//*********************************************************************
// [COMIDAS sample program by COMIZOA Inc., Ltd]
//
// Subject : 
//   Motion Control, List Motion
// Contents: 
//   -.   Ʈ   뿹 ̱  Դϴ. 
//	 -.   Ʈ ޴ 312 "[׸ 3-22] ӵ Ӽ 
//	      In-Position "  ׸  ۾  
//	    ׷Դϴ. 
//	 -.   带 Ͽ X  ġ  ӵ Ͽ ȭ
//		 ǥϰ,  C:\motion.txt Ͽ մϴ. ڴ  
//	    ͸ Ȯϸ  θ Ȯ  ֽϴ.
// Remarks:
//   -.  α׷ COMI-LX501  Դϴ. 
//*********************************************************************

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "comidaslx.h"

// (ä) ȣ //
#define X_AXIS	0

BOOL bAbortThread;

//*********************************************************************
// Monitor_Log_Thread() : X  ġ   ӵ  Ͽ ȭ
// α Ͽ ǥϱ   Լ
//*********************************************************************
DWORD WINAPI Monitor_Log_Thread(LPVOID lpParameter)
{
	HANDLE hDevice = (HANDLE)lpParameter;
	double fPos, fSpeed;
	FILE *fp;
	if((fp = fopen("c:\\motion.txt", "w")) == NULL){
		printf("c:\\motion.txt    Ƿ ġ α ͸   ϴ.\n");
		printf("ƹŰ   ۾  ˴ϴ.\n");
		getch();
	}
	bAbortThread = FALSE;
	while(!bAbortThread)
	{
		fPos = COMILX_MC_GetPosition_C(hDevice, X_AXIS);
		fSpeed = COMILX_MC_GetCurSpeed(hDevice, X_AXIS);
		printf("Position (X, Y) = (%.0f, %.0f)\n", fPos, fSpeed);
		if(fp) fprintf(fp, "%.0f	%.0f\n", fPos, fSpeed);
	}
	if(fp) fclose(fp);
	bAbortThread=FALSE;
	return 0;
}

void main()
{
	double fDistList[2];

	if(!COMILX_LoadDll())
		exit(-1); // Load Dll Failure
	
	HANDLE hDevice = COMILX_LoadDevice(COMI_LX501, 0);
	if(hDevice == INVALID_HANDLE_VALUE)
		exit(-1); // Load Device Failure
	
	COMILX_MC_Reset(hDevice);

	COMILX_MC_BeginList(hDevice); //  Ʈ   //
		// Set Trapezoidal Speed Mode //
		COMILX_MC_SetSpeedMode(hDevice, X_AXIS, 1); 
		// Move (1) //
		COMILX_MC_SetSpeed(hDevice, X_AXIS, 0, 1000);
		COMILX_MC_SetAccel(hDevice, X_AXIS, 2000, 0);
		COMILX_MC_MoveTo(hDevice, X_AXIS, 3000);
		// Move (2) //
		COMILX_MC_SetSpeed(hDevice, X_AXIS, 1000, 3000);
		COMILX_MC_SetAccel(hDevice, X_AXIS, 2000, 2000);
		COMILX_MC_MoveTo(hDevice, X_AXIS, 8000);
		// Move (3) //
		COMILX_MC_SetSpeed(hDevice, X_AXIS, 0, 1000);
		COMILX_MC_SetAccel(hDevice, X_AXIS, 0, 2000);
		COMILX_MC_MoveTo(hDevice, X_AXIS, 11000);
	COMILX_MC_EndList(hDevice); //  Ʈ  ħ //

	// X  ġ  ӵ  ȭ α Ͽ ǥϱ 	//
	// Monitor_Log_Thread 带 Ѵ.					//
	CreateThread(NULL, 0, Monitor_Log_Thread, hDevice, 0, NULL);

	COMILX_MC_StartListMotion(hDevice); // Ʈ   //
	// Ʈ   Ϸ  ٸ //
	while(!COMILX_MC_CheckListMotionDone(hDevice))
		;
	
	bAbortThread=TRUE; // Monitor_Log_Thread  Ų.
	while(bAbortThread) // Monitor_Log_Thread 尡   ٸ.
		;
	COMILX_UnloadDevice(hDevice);
	COMILX_UnloadDll();
}


